local assets = {
    Asset("ANIM", "anim/aegis_rig.zip"),
    Asset("ANIM", "anim/swap_aegis_rig.zip"),
    
    Asset( "IMAGE", "images/inventoryimages/aegis_rig.tex" ),
	Asset( "ATLAS", "images/inventoryimages/aegis_rig.xml" ),
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_aegis_rig", "swap_aegis_rig")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
	inst:DoTaskInTime(1 * FRAMES, function() inst:Remove() end)
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
	inst.persists = false

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("aegis_rig")
    inst.AnimState:SetBuild("aegis_rig")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/aegis_rig.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE)
    
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.HAMMER, 100)

    return inst
end

return Prefab("aegis_rig", fn, assets)